﻿using System;

namespace StringSplit
{
    class Program
    {
        static void Main(string[] args)
        {
            ShowArray(SplitByArray("Jeden,Dwa Trzy, Cztery. Pięć."));
            ShowArray(SplitByParams("Jeden,Dwa Trzy, Cztery. Pięć."));
        }

        static void ShowArray(string[] array)
        {
            foreach (string item in array)
            {
                Console.WriteLine(item);
            }
            Console.WriteLine();
        }

        static string[] SplitByArray(string inputString)
        {
            // Listing 7-8. Argumenty tablicowe w bibliotece klas.
            string[] items = inputString.Split(
                new char[] { ' ', ',', '.' },
                StringSplitOptions.RemoveEmptyEntries);

            return items;
        }

        static string[] SplitByParams(string inputString)
        {
            string[] items = inputString.Split(' ', ',', '.');

            return items;
        }

    }
}
